<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="form-container">
    <h1 class="form-title">Авторизация</h1>

    <?php $form = ActiveForm::begin([
        'id' => 'login-form',
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'help-block'],
        ],
    ]); ?>

    <?= $form->field($model, 'email')->textInput([
        'autofocus' => true, 
        'type' => 'email',
        'placeholder' => 'example@mail.ru'
    ]) ?>

    <?= $form->field($model, 'password')->passwordInput([
        'placeholder' => 'Введите ваш пароль'
    ]) ?>

    <?= $form->field($model, 'rememberMe')->checkbox([
        'template' => "<div class=\"form-check\">{input} {label}</div>\n{error}",
    ]) ?>

    <div class="form-group">
        <?= Html::submitButton('Войти', ['class' => 'btn btn-primary btn-block', 'name' => 'login-button']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="form-link">
        <p>Еще не зарегистрированы? <a href="<?= Yii::$app->urlManager->createUrl(['site/register']) ?>">Регистрация</a></p>
    </div>
</div>