<?php
use yii\helpers\Html;

$this->title = 'HR-Portal - Система управления персоналом';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="site-index">
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">
                        Добро пожаловать в <span class="highlight">HR-Portal</span>
                    </h1>
                    <p class="hero-description">
                        Современная система управления персоналом для эффективной работы с кадровыми данными. 
                        Упростите процессы оформления сотрудников и управляйте анкетами в одном месте.
                    </p>
                    <div class="hero-buttons">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <?= Html::a('Начать работу', ['site/register'], ['class' => 'btn btn-primary btn-lg']) ?>
                            <?= Html::a('Уже есть аккаунт', ['site/login'], ['class' => 'btn btn-outline btn-lg']) ?>
                        <?php else: ?>
                            <?php if (Yii::$app->user->identity->is_admin): ?>
                                <?= Html::a('Панель администратора', ['admin/index'], ['class' => 'btn btn-primary btn-lg']) ?>
                            <?php else: ?>
                                <?= Html::a('Заполнить анкету', ['profile/questionnaire'], ['class' => 'btn btn-primary btn-lg']) ?>
                                <?= Html::a('Личный кабинет', ['profile/cabinet'], ['class' => 'btn btn-outline btn-lg']) ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="hero-image">
                    <div class="floating-card">
                        <div class="card-icon">👥</div>
                        <h3>Управление персоналом</h3>
                        <p>Эффективная работа с кадровыми данными</p>
                    </div>
                    <div class="floating-card">
                        <div class="card-icon">📊</div>
                        <h3>Аналитика</h3>
                        <p>Подробная статистика и отчетность</p>
                    </div>
                    <div class="floating-card">
                        <div class="card-icon">🔒</div>
                        <h3>Безопасность</h3>
                        <p>Защита персональных данных</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
        <div class="container">
            <h2 class="section-title">Возможности системы</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">📝</div>
                    <h3>Электронные анкеты</h3>
                    <p>Сотрудники заполняют анкеты онлайн, все данные хранятся в безопасном цифровом формате</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">⚡</div>
                    <h3>Быстрая обработка</h3>
                    <p>Автоматизация процессов проверки и утверждения анкет сотрудников</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🔍</div>
                    <h3>Детальная аналитика</h3>
                    <p>Фильтрация и сортировка данных по различным параметрам для анализа</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🛡️</div>
                    <h3>Безопасность данных</h3>
                    <p>Многоуровневая система защиты персональной информации сотрудников</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-item">
                    <div class="stat-number">100%</div>
                    <div class="stat-label">Электронный документооборот</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">24/7</div>
                    <div class="stat-label">Доступность системы</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">⏱️</div>
                    <div class="stat-label">Экономия времени</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">🔐</div>
                    <div class="stat-label">Защита данных</div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
/* Hero Section */
.hero-section {
    padding: 8vh 0;
    background: linear-gradient(135deg, #20B2AA 0%, #40E0D0 100%);
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000" opacity="0.1"><polygon fill="white" points="0,1000 1000,0 1000,1000"/></svg>');
    background-size: cover;
}

.hero-content {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 6vh;
    align-items: center;
    position: relative;
    z-index: 2;
}

.hero-title {
    font-size: 5vh;
    font-weight: 800;
    margin-bottom: 2vh;
    line-height: 1.2;
}

.highlight {
    color: #f0fff0;
    text-shadow: 0 2px 4px rgba(0,0,0,0.3);
}

.hero-description {
    font-size: 2.2vh;
    margin-bottom: 4vh;
    opacity: 0.9;
    line-height: 1.6;
}

.hero-buttons {
    display: flex;
    gap: 2vh;
    flex-wrap: wrap;
}

.btn-lg {
    padding: 1.8vh 3.5vh;
    font-size: 2vh;
    border-radius: 12px;
}

.btn-outline {
    background: transparent;
    border: 2px solid rgba(255, 255, 255, 0.3);
    color: white;
}

.btn-outline:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.5);
    color: white;
}

.hero-image {
    position: relative;
    height: 40vh;
}

.floating-card {
    position: absolute;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    padding: 3vh;
    text-align: center;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.floating-card:nth-child(1) {
    top: 0;
    left: 0;
    animation: float 3s ease-in-out infinite;
}

.floating-card:nth-child(2) {
    top: 50%;
    right: 0;
    transform: translateY(-50%);
    animation: float 3s ease-in-out infinite 1s;
}

.floating-card:nth-child(3) {
    bottom: 0;
    left: 20%;
    animation: float 3s ease-in-out infinite 2s;
}

.card-icon {
    font-size: 4vh;
    margin-bottom: 1vh;
}

.floating-card h3 {
    font-size: 2vh;
    margin-bottom: 1vh;
    font-weight: 600;
}

.floating-card p {
    font-size: 1.6vh;
    opacity: 0.8;
}

@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

/* Features Section */
.features-section {
    padding: 8vh 0;
    background: #f8fdfc;
}

.section-title {
    text-align: center;
    font-size: 4vh;
    font-weight: 700;
    color: #20B2AA;
    margin-bottom: 6vh;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 4vh;
}

.feature-card {
    background: white;
    padding: 4vh;
    border-radius: 16px;
    text-align: center;
    box-shadow: 0 4px 20px rgba(32, 178, 170, 0.1);
    transition: all 0.3s ease;
    border: 1px solid #e0f7fa;
}

.feature-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(32, 178, 170, 0.2);
}

.feature-icon {
    font-size: 5vh;
    margin-bottom: 2vh;
}

.feature-card h3 {
    font-size: 2.2vh;
    font-weight: 600;
    color: #20B2AA;
    margin-bottom: 1.5vh;
}

.feature-card p {
    font-size: 1.8vh;
    color: #2c3e50;
    line-height: 1.5;
}

/* Stats Section */
.stats-section {
    padding: 6vh 0;
    background: linear-gradient(135deg, #20B2AA 0%, #40E0D0 100%);
    color: white;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 4vh;
    text-align: center;
}

.stat-item {
    padding: 3vh;
}

.stat-number {
    font-size: 4vh;
    font-weight: 800;
    margin-bottom: 1vh;
}

.stat-label {
    font-size: 1.8vh;
    opacity: 0.9;
}

/* Responsive */
@media (max-width: 768px) {
    .hero-content {
        grid-template-columns: 1fr;
        text-align: center;
    }
    
    .hero-title {
        font-size: 4vh;
    }
    
    .hero-buttons {
        justify-content: center;
    }
    
    .hero-image {
        height: 30vh;
    }
    
    .floating-card {
        position: relative;
        margin-bottom: 2vh;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
    }
}
</style>