<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\web\UploadedFile;

$this->title = 'Анкета сотрудника';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="form-container">
    <h1 class="form-title">Анкета сотрудника</h1>

    <?php $form = ActiveForm::begin([
        'options' => ['enctype' => 'multipart/form-data'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'help-block'],
        ],
    ]); ?>

    <div class="card">
        <h2 class="card-title">Основная информация</h2>
        
        <div class="form-group">
            <label class="form-label">ФИО</label>
            <input type="text" class="form-control" value="<?= Html::encode($user->full_name) ?>" readonly style="background-color: #f8f9fa;">
        </div>

        <div class="form-group">
            <label class="form-label">Телефон</label>
            <input type="text" class="form-control" value="<?= Html::encode($user->phone) ?>" readonly style="background-color: #f8f9fa;">
        </div>

        <div class="form-group">
            <label class="form-label">Email</label>
            <input type="text" class="form-control" value="<?= Html::encode($user->email) ?>" readonly style="background-color: #f8f9fa;">
        </div>

        <?= $form->field($model, 'photoFile')->fileInput(['class' => 'file-input']) ?>

        <?= $form->field($model, 'birth_date')->input('date') ?>

        <?= $form->field($model, 'gender')->dropDownList([
            'Мужской' => 'Мужской',
            'Женский' => 'Женский'
        ], ['prompt' => 'Выберите пол']) ?>

        <?= $form->field($model, 'citizenship')->textInput() ?>
    </div>

    <div class="card">
        <h2 class="card-title">Паспортные данные</h2>
        
        <div class="row">
            <div class="col-md-6">
                <?= $form->field($model, 'passport_series')->textInput(['maxlength' => 4]) ?>
            </div>
            <div class="col-md-6">
                <?= $form->field($model, 'passport_number')->textInput(['maxlength' => 6]) ?>
            </div>
        </div>

        <?= $form->field($model, 'passport_issued_by')->textInput() ?>

        <?= $form->field($model, 'passport_issued_date')->input('date') ?>

        <?= $form->field($model, 'registration_address')->textInput() ?>

        <?= $form->field($model, 'passportScanFile')->fileInput(['class' => 'file-input']) ?>

        <?= $form->field($model, 'marital_status')->dropDownList([
            'Холост/Не замужем' => 'Холост/Не замужем',
            'Женат/Замужем' => 'Женат/Замужем',
            'Разведен/Разведена' => 'Разведен/Разведена',
            'Вдовец/Вдова' => 'Вдовец/Вдова'
        ], ['prompt' => 'Выберите семейное положение']) ?>
    </div>

    <div class="card">
        <h2 class="card-title">Образование</h2>
        
        <?= $form->field($model, 'education')->dropDownList([
            'Основное общее' => 'Основное общее',
            'Среднее общее' => 'Среднее общее',
            'Среднее профессиональное' => 'Среднее профессиональное',
            'Высшее' => 'Высшее'
        ], ['prompt' => 'Выберите уровень образования']) ?>

        <?= $form->field($model, 'educational_institution')->textInput() ?>

        <?= $form->field($model, 'specialization')->textInput() ?>

        <?= $form->field($model, 'diploma_series_number')->textInput() ?>

        <?= $form->field($model, 'diplomaScanFile')->fileInput(['class' => 'file-input']) ?>
    </div>

    <div class="card">
        <h2 class="card-title">Прочая информация</h2>
        
        <?= $form->field($model, 'snils')->textInput() ?>

        <?= $form->field($model, 'snilsScanFile')->fileInput(['class' => 'file-input']) ?>

        <?= $form->field($model, 'work_place')->textInput() ?>

        <?= $form->field($model, 'position')->textInput() ?>

        <?= $form->field($model, 'work_experience')->textInput() ?>

        <?= $form->field($model, 'health_status')->textarea(['rows' => 3]) ?>

        <?= $form->field($model, 'additional_info')->textarea(['rows' => 4]) ?>
    </div>

    <div class="form-group">
        <?= Html::submitButton('Передать данные', ['class' => 'btn btn-primary btn-block']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>