<?php
use yii\helpers\Html;

$this->title = 'Личный кабинет';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="form-container">
    <h1 class="form-title">Личный кабинет</h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <h2 class="card-title">Основная информация</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">ФИО:</span>
                <span class="profile-value"><?= Html::encode($user->full_name) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Телефон:</span>
                <span class="profile-value"><?= Html::encode($user->phone) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Email:</span>
                <span class="profile-value"><?= Html::encode($user->email) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Дата рождения:</span>
                <span class="profile-value"><?= Html::encode($model->birth_date) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Пол:</span>
                <span class="profile-value"><?= Html::encode($model->gender) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Гражданство:</span>
                <span class="profile-value"><?= Html::encode($model->citizenship) ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Паспортные данные</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">Серия и номер:</span>
                <span class="profile-value"><?= Html::encode($model->passport_series) ?> <?= Html::encode($model->passport_number) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Кем и когда выдан:</span>
                <span class="profile-value"><?= Html::encode($model->passport_issued_by) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Дата выдачи:</span>
                <span class="profile-value"><?= Html::encode($model->passport_issued_date) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Адрес регистрации:</span>
                <span class="profile-value"><?= Html::encode($model->registration_address) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Семейное положение:</span>
                <span class="profile-value"><?= Html::encode($model->marital_status) ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Образование</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">Образование:</span>
                <span class="profile-value"><?= Html::encode($model->education) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Образовательная организация:</span>
                <span class="profile-value"><?= Html::encode($model->educational_institution) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Специальность:</span>
                <span class="profile-value"><?= Html::encode($model->specialization) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Серия и номер диплома:</span>
                <span class="profile-value"><?= Html::encode($model->diploma_series_number) ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Прочая информация</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">СНИЛС:</span>
                <span class="profile-value"><?= Html::encode($model->snils) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Место работы:</span>
                <span class="profile-value"><?= Html::encode($model->work_place) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Должность:</span>
                <span class="profile-value"><?= Html::encode($model->position) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Стаж работы:</span>
                <span class="profile-value"><?= Html::encode($model->work_experience) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Состояние здоровья:</span>
                <span class="profile-value"><?= Html::encode($model->health_status) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Дополнительная информация:</span>
                <span class="profile-value"><?= Html::encode($model->additional_info) ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Статус анкеты</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">Статус:</span>
                <span class="profile-value">
                    <?php
                    $statusClass = '';
                    switch ($model->status) {
                        case 'Новая': $statusClass = 'status-new'; break;
                        case 'Идет проверка данных': $statusClass = 'status-in-progress'; break;
                        case 'Данные приняты': $statusClass = 'status-accepted'; break;
                    }
                    ?>
                    <span class="<?= $statusClass ?>"><?= Html::encode($model->status) ?></span>
                </span>
            </div>
        </div>
    </div>

    <div class="form-group">
        <?= Html::a('Редактировать данные', ['questionnaire'], ['class' => 'btn btn-primary btn-block']) ?>
    </div>
</div>