<?php
use yii\helpers\Html;
use app\models\EmployeeProfile;

$this->title = 'Просмотр анкеты сотрудника';
$this->params['breadcrumbs'][] = ['label' => 'Панель администратора', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-view">
    <div class="admin-header">
        <h1 class="admin-title">Просмотр анкеты сотрудника</h1>
        <p class="admin-subtitle">Детальная информация по анкете</p>
    </div>

    <div class="action-buttons mb-4">
        <?= Html::a('← Назад к списку', ['index'], ['class' => 'btn btn-secondary']) ?>
        <?= Html::a('📝 Изменить статус', ['update-status', 'id' => $model->id], [
            'class' => 'btn btn-primary',
            'data' => ['method' => 'post']
        ]) ?>
    </div>

    <div class="card">
        <h2 class="card-title">Основная информация</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">ФИО:</span>
                <span class="profile-value"><?= Html::encode($model->user->full_name ?? '') ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Телефон:</span>
                <span class="profile-value"><?= Html::encode($model->user->phone ?? '') ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Email:</span>
                <span class="profile-value"><?= Html::encode($model->user->email ?? '') ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Дата рождения:</span>
                <span class="profile-value"><?= Html::encode($model->birth_date) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Пол:</span>
                <span class="profile-value"><?= Html::encode($model->gender) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Гражданство:</span>
                <span class="profile-value"><?= Html::encode($model->citizenship) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Статус анкеты:</span>
                <span class="profile-value">
                    <?php
                    $statusClass = '';
                    switch ($model->status) {
                        case 'Новая': $statusClass = 'status-new'; break;
                        case 'Идет проверка данных': $statusClass = 'status-in-progress'; break;
                        case 'Данные приняты': $statusClass = 'status-accepted'; break;
                    }
                    ?>
                    <span class="<?= $statusClass ?>"><?= Html::encode($model->status) ?></span>
                </span>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Паспортные данные</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">Серия и номер:</span>
                <span class="profile-value"><?= Html::encode($model->passport_series) ?> <?= Html::encode($model->passport_number) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Кем и когда выдан:</span>
                <span class="profile-value"><?= Html::encode($model->passport_issued_by) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Дата выдачи:</span>
                <span class="profile-value"><?= Html::encode($model->passport_issued_date) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Адрес регистрации:</span>
                <span class="profile-value"><?= Html::encode($model->registration_address) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Семейное положение:</span>
                <span class="profile-value"><?= Html::encode($model->marital_status) ?></span>
            </div>
            <?php if ($model->passport_scan): ?>
            <div class="profile-item">
                <span class="profile-label">Скан паспорта:</span>
                <span class="profile-value">
                    <?= Html::a('📎 Скачать', ['/uploads/passports/' . $model->passport_scan], [
                        'target' => '_blank',
                        'class' => 'btn btn-sm btn-outline'
                    ]) ?>
                </span>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Образование</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">Образование:</span>
                <span class="profile-value"><?= Html::encode($model->education) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Образовательная организация:</span>
                <span class="profile-value"><?= Html::encode($model->educational_institution) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Специальность:</span>
                <span class="profile-value"><?= Html::encode($model->specialization) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Серия и номер диплома:</span>
                <span class="profile-value"><?= Html::encode($model->diploma_series_number) ?></span>
            </div>
            <?php if ($model->diploma_scan): ?>
            <div class="profile-item">
                <span class="profile-label">Скан диплома:</span>
                <span class="profile-value">
                    <?= Html::a('📎 Скачать', ['/uploads/diplomas/' . $model->diploma_scan], [
                        'target' => '_blank',
                        'class' => 'btn btn-sm btn-outline'
                    ]) ?>
                </span>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Прочая информация</h2>
        <div class="profile-info">
            <div class="profile-item">
                <span class="profile-label">СНИЛС:</span>
                <span class="profile-value"><?= Html::encode($model->snils) ?></span>
            </div>
            <?php if ($model->snils_scan): ?>
            <div class="profile-item">
                <span class="profile-label">Скан СНИЛС:</span>
                <span class="profile-value">
                    <?= Html::a('📎 Скачать', ['/uploads/snils/' . $model->snils_scan], [
                        'target' => '_blank',
                        'class' => 'btn btn-sm btn-outline'
                    ]) ?>
                </span>
            </div>
            <?php endif; ?>
            <div class="profile-item">
                <span class="profile-label">Место работы:</span>
                <span class="profile-value"><?= Html::encode($model->work_place) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Должность:</span>
                <span class="profile-value"><?= Html::encode($model->position) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Стаж работы:</span>
                <span class="profile-value"><?= Html::encode($model->work_experience) ?> лет</span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Состояние здоровья:</span>
                <span class="profile-value"><?= Html::encode($model->health_status) ?></span>
            </div>
            <div class="profile-item">
                <span class="profile-label">Дополнительная информация:</span>
                <span class="profile-value"><?= Html::encode($model->additional_info) ?></span>
            </div>
        </div>
    </div>

    <?php if ($model->photo): ?>
    <div class="card">
        <h2 class="card-title">Фото сотрудника</h2>
        <div class="text-center">
            <?= Html::img('/uploads/photos/' . $model->photo, [
                'class' => 'employee-photo',
                'alt' => 'Фото сотрудника',
                'style' => 'max-width: 300px; border-radius: 12px;'
            ]) ?>
            <div class="mt-2">
                <?= Html::a('📎 Скачать фото', ['/uploads/photos/' . $model->photo], [
                    'target' => '_blank',
                    'class' => 'btn btn-sm btn-outline'
                ]) ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="action-buttons mt-4">
        <?= Html::a('← Назад к списку', ['index'], ['class' => 'btn btn-secondary']) ?>
        <div class="status-buttons">
            <?php foreach (EmployeeProfile::getStatuses() as $statusKey => $statusName): ?>
                <?php if ($statusKey !== $model->status): ?>
                    <?= Html::a($statusName, ['update-status', 'id' => $model->id, 'status' => $statusKey], [
                        'class' => 'btn btn-primary',
                        'data' => ['method' => 'post']
                    ]) ?>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<style>
.employee-photo {
    max-width: 300px;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.status-buttons {
    display: flex;
    gap: 1vh;
    flex-wrap: wrap;
}

.action-buttons {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 2vh;
}

@media (max-width: 768px) {
    .action-buttons {
        flex-direction: column;
        text-align: center;
    }
    
    .status-buttons {
        justify-content: center;
    }
}
</style>