<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use app\models\EmployeeProfile;

$this->title = 'Изменение статуса анкеты';
$this->params['breadcrumbs'][] = ['label' => 'Панель администратора', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => 'Просмотр анкеты', 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-update-status">
    <div class="admin-header">
        <h1 class="admin-title">Изменение статуса анкеты</h1>
        <p class="admin-subtitle">Выберите новый статус для анкеты сотрудника</p>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="employee-info mb-4">
                <h3 class="info-title">Информация о сотруднике</h3>
                <div class="info-grid">
                    <div class="info-item">
                        <span class="info-label">ФИО:</span>
                        <span class="info-value"><?= Html::encode($model->user->full_name ?? '') ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Должность:</span>
                        <span class="info-value"><?= Html::encode($model->position) ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Текущий статус:</span>
                        <span class="info-value">
                            <?php
                            $statusClass = '';
                            switch ($currentStatus) {
                                case 'Новая': $statusClass = 'status-new'; break;
                                case 'Идет проверка данных': $statusClass = 'status-in-progress'; break;
                                case 'Данные приняты': $statusClass = 'status-accepted'; break;
                            }
                            ?>
                            <span class="<?= $statusClass ?>"><?= Html::encode($currentStatus) ?></span>
                        </span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Дата создания:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDatetime($model->created_at) ?></span>
                    </div>
                </div>
            </div>

            <?php $form = ActiveForm::begin([
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'help-block'],
                ],
            ]); ?>

            <div class="status-selection">
                <h3 class="selection-title">Выберите новый статус</h3>
                
                <div class="status-options">
                    <?php foreach (EmployeeProfile::getStatuses() as $statusKey => $statusName): ?>
                        <div class="status-option">
                            <input type="radio" 
                                   name="status" 
                                   value="<?= $statusKey ?>" 
                                   id="status-<?= $statusKey ?>" 
                                   <?= $currentStatus === $statusKey ? 'checked' : '' ?>
                                   class="status-radio">
                            <label for="status-<?= $statusKey ?>" class="status-label">
                                <span class="status-indicator status-<?= $statusKey ?>"></span>
                                <span class="status-text"><?= $statusName ?></span>
                                <?php if ($currentStatus === $statusKey): ?>
                                    <span class="current-badge">Текущий</span>
                                <?php endif; ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="form-actions mt-4">
                <?= Html::submitButton('Сохранить изменения', ['class' => 'btn btn-primary btn-lg']) ?>
                <?= Html::a('Отмена', ['view', 'id' => $model->id], ['class' => 'btn btn-secondary btn-lg']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <div class="quick-actions mt-4">
        <h3 class="actions-title">Быстрые действия</h3>
        <div class="action-buttons">
            <?php foreach (EmployeeProfile::getStatuses() as $statusKey => $statusName): ?>
                <?php if ($statusKey !== $currentStatus): ?>
                    <?= Html::a($statusName, ['quick-update-status', 'id' => $model->id, 'status' => $statusKey], [
                        'class' => 'btn btn-outline',
                        'data' => ['method' => 'post', 'confirm' => "Вы уверены, что хотите изменить статус на '$statusName'?"]
                    ]) ?>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<style>
.admin-update-status {
    max-width: 800px;
    margin: 0 auto;
}

.info-title {
    color: #20B2AA;
    font-size: 2.2vh;
    font-weight: 600;
    margin-bottom: 2vh;
    border-bottom: 2px solid #e0f7fa;
    padding-bottom: 1vh;
}

.info-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5vh;
}

.info-item {
    display: flex;
    flex-direction: column;
    padding: 1.5vh;
    background: #f8fdfc;
    border-radius: 8px;
    border: 1px solid #e0f7fa;
}

.info-label {
    font-weight: 600;
    color: #20B2AA;
    font-size: 1.6vh;
    margin-bottom: 0.5vh;
}

.info-value {
    color: #2c3e50;
    font-size: 1.8vh;
}

/* Status Selection */
.selection-title {
    color: #20B2AA;
    font-size: 2.2vh;
    font-weight: 600;
    margin-bottom: 2vh;
}

.status-options {
    display: flex;
    flex-direction: column;
    gap: 1.5vh;
}

.status-option {
    position: relative;
}

.status-radio {
    position: absolute;
    opacity: 0;
}

.status-label {
    display: flex;
    align-items: center;
    padding: 2vh;
    border: 2px solid #e0f7fa;
    border-radius: 12px;
    cursor: pointer;
    transition: all 0.3s ease;
    background: #f8fdfc;
    position: relative;
}

.status-radio:checked + .status-label {
    border-color: #20B2AA;
    background: #e8f8f5;
    box-shadow: 0 0 0 3px rgba(32, 178, 170, 0.1);
}

.status-label:hover {
    border-color: #40E0D0;
    background: #f0f8f5;
}

.status-indicator {
    width: 2vh;
    height: 2vh;
    border-radius: 50%;
    margin-right: 1.5vh;
    border: 2px solid #ccc;
    position: relative;
}

.status-radio:checked + .status-label .status-indicator {
    border-color: #20B2AA;
}

.status-radio:checked + .status-label .status-indicator::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 1vh;
    height: 1vh;
    border-radius: 50%;
    background: #20B2AA;
}

.status-new .status-indicator {
    border-color: #ffeaa7;
}

.status-in-progress .status-indicator {
    border-color: #81ecec;
}

.status-accepted .status-indicator {
    border-color: #55efc4;
}

.status-radio:checked + .status-new .status-indicator {
    border-color: #ffeaa7;
}

.status-radio:checked + .status-new .status-indicator::after {
    background: #ffeaa7;
}

.status-radio:checked + .status-in-progress .status-indicator {
    border-color: #81ecec;
}

.status-radio:checked + .status-in-progress .status-indicator::after {
    background: #81ecec;
}

.status-radio:checked + .status-accepted .status-indicator {
    border-color: #55efc4;
}

.status-radio:checked + .status-accepted .status-indicator::after {
    background: #55efc4;
}

.status-text {
    font-size: 1.8vh;
    font-weight: 500;
    color: #2c3e50;
    flex: 1;
}

.current-badge {
    background: #20B2AA;
    color: white;
    padding: 0.5vh 1vh;
    border-radius: 12px;
    font-size: 1.4vh;
    font-weight: 600;
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 2vh;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-lg {
    padding: 1.5vh 3vh;
    font-size: 1.8vh;
    min-width: 200px;
}

/* Quick Actions */
.quick-actions {
    background: white;
    border-radius: 16px;
    padding: 3vh;
    box-shadow: 0 4px 20px rgba(32, 178, 170, 0.1);
    border: 1px solid #e0f7fa;
}

.actions-title {
    color: #20B2AA;
    font-size: 2vh;
    font-weight: 600;
    margin-bottom: 2vh;
    text-align: center;
}

.action-buttons {
    display: flex;
    gap: 1.5vh;
    justify-content: center;
    flex-wrap: wrap;
}

/* Status badges for current status */
.status-new, .status-in-progress, .status-accepted {
    padding: 0.6vh 1.2vh;
    border-radius: 20px;
    font-size: 1.4vh;
    font-weight: 600;
    display: inline-block;
}

.status-new {
    background: #ffeaa7;
    color: #2d3436;
}

.status-in-progress {
    background: #81ecec;
    color: #2d3436;
}

.status-accepted {
    background: #55efc4;
    color: #2d3436;
}

/* Responsive */
@media (max-width: 768px) {
    .info-grid {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-lg {
        min-width: auto;
        width: 100%;
        max-width: 300px;
    }
    
    .action-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .action-buttons .btn {
        width: 100%;
        max-width: 250px;
    }
}
</style>