<?php

namespace app\models;

use Yii;
use yii\base\Model;

class RegisterForm extends Model
{
    public $full_name;
    public $phone;
    public $email;
    public $password;
    public $password_repeat;
    public $agree_terms;

    public function rules()
    {
        return [
            [['full_name', 'phone', 'email', 'password', 'password_repeat', 'agree_terms'], 'required', 'message' => 'Это поле обязательно для заполнения'],
            [['full_name'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s]+$/u', 'message' => 'ФИО должно содержать только кириллические символы и пробелы'],
            [['phone'], 'match', 'pattern' => '/^\+7\(\d{3}\)\d{3}-\d{2}-\d{2}$/', 'message' => 'Телефон должен быть в формате +7(XXX)XXX-XX-XX'],
            [['email'], 'email', 'message' => 'Введите корректный email адрес'],
            [['password'], 'string', 'min' => 7, 'tooShort' => 'Пароль должен содержать минимум 7 символов'],
            [['password_repeat'], 'compare', 'compareAttribute' => 'password', 'message' => 'Пароли не совпадают'],
            [['agree_terms'], 'compare', 'compareValue' => true, 'message' => 'Вы должны согласиться с правилами регистрации'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'full_name' => 'ФИО',
            'phone' => 'Телефон',
            'email' => 'Почта',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
            'agree_terms' => 'Я согласен с правилами регистрации',
        ];
    }

    public function register()
    {
        if (!$this->validate()) {
            return false;
        }

        $user = new User();
        $user->full_name = $this->full_name;
        $user->phone = $this->phone;
        $user->email = $this->email;
        $user->setPassword($this->password);

        if ($user->save()) {
            return Yii::$app->user->login($user, 0);
        }

        return false;
    }
}