<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%employee_profile}}`.
 */
class m251221_155007_create_employee_profile_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%employee_profile}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'photo' => $this->string(500)->null(),
            'birth_date' => $this->date()->null(),
            'gender' => $this->string(10)->null()->comment('male, female'),
            'citizenship' => $this->string(100)->null(),
            
            // Паспортные данные
            'passport_series' => $this->string(10)->null(),
            'passport_number' => $this->string(20)->null(),
            'passport_issued_by' => $this->text()->null(),
            'passport_issued_date' => $this->date()->null(),
            'registration_address' => $this->text()->null(),
            'passport_scan' => $this->string(500)->null(),
            
            // Личные данные
            'marital_status' => $this->string(50)->null()->comment('Холост/не замужем, Женат/замужем, Разведен(а), Вдовец/вдова'),
            
            // Образование
            'education' => $this->string(100)->null()->comment('Основное общее, Среднее общее, Среднее профессиональное, Высшее'),
            'educational_institution' => $this->string(500)->null(),
            'specialization' => $this->string(500)->null(),
            'diploma_series_number' => $this->string(100)->null(),
            'diploma_scan' => $this->string(500)->null(),
            
            // СНИЛС
            'snils' => $this->string(20)->null(),
            'snils_scan' => $this->string(500)->null(),
            
            // Работа
            'work_place' => $this->string(500)->null(),
            'position' => $this->string(255)->null(),
            'work_experience' => $this->decimal(4,1)->null()->comment('Стаж в годах'),
            
            // Дополнительно
            'health_status' => $this->text()->null(),
            'additional_info' => $this->text()->null(),
            
            // Статус анкеты
            'status' => $this->string(50)->defaultValue('new')->comment('new, checking, accepted'),
            
            // Временные метки
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
            'submitted_at' => $this->integer()->null(),
            'reviewed_at' => $this->integer()->null(),
        ]);

         $this->addForeignKey(
            'fk-employee_profile-user_id',
            '{{%employee_profile}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
         );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%employee_profile}}');
    }
}
