<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\EmployeeProfile;
use yii\web\UploadedFile;

class ProfileController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                        // Админы и обычные пользователи имеют доступ
                    ],
                ],
            ],
        ];
    }

    public function actionQuestionnaire()
    {
        $user = Yii::$app->user->identity;
        
        // Если админ, используем его user_id для анкеты
        $model = EmployeeProfile::findOne(['user_id' => $user->id]);

        if (!$model) {
            $model = new EmployeeProfile();
            $model->user_id = $user->id;
        }

        if ($model->load(Yii::$app->request->post())) {
            // Загружаем файлы
            $model->photoFile = UploadedFile::getInstance($model, 'photoFile');
            $model->passportScanFile = UploadedFile::getInstance($model, 'passportScanFile');
            $model->diplomaScanFile = UploadedFile::getInstance($model, 'diplomaScanFile');
            $model->snilsScanFile = UploadedFile::getInstance($model, 'snilsScanFile');
            
            if ($model->validate()) {
                if ($model->save()) {
                    Yii::$app->session->setFlash('success', 'Анкета успешно сохранена и отправлена на проверку.');
                    return $this->redirect(['cabinet']);
                } else {
                    Yii::$app->session->setFlash('error', 'Ошибка при сохранении анкеты.');
                }
            }
        }

        return $this->render('questionnaire', [
            'model' => $model,
            'user' => $user,
        ]);
    }

    public function actionCabinet()
    {
        $user = Yii::$app->user->identity;
        $model = EmployeeProfile::findOne(['user_id' => $user->id]);

        if (!$model) {
            return $this->redirect(['questionnaire']);
        }

        return $this->render('cabinet', [
            'model' => $model,
            'user' => $user,
        ]);
    }
}